#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								      MEMO
//********************************************************************************
/*-IR remote decode
Head   : Low(9ms) + High(4.5ms) 
Stop   : Low(39.8ms)

640us,1.64ms
1 = Low(640us) + High(640us)
0 = Low(640us) + High(1.64ms)

First remote control:
				    Adress 16bits              Data 16bits
	"1" 	=	0000 0000 1111 1111			1010 0010 0101 1101
	"2"		=	0000 0000 1111 1111         0110 0010 1001 1101
	"3"		=	0000 0000 1111 1111			1110 0010 0001 1101
	"4"		=	0000 0000 1111 1111			0010 0010 1101 1101
	"5"		=	0000 0000 1111 1111			0000 0010 1111 1101	
	"6"		=	0000 0000 1111 1111			1100 0010 0011 1101
	"7"		=	0000 0000 1111 1111	 		1110 0000 0001 1111
	"8"		=	0000 0000 1111 1111			1010 1000 0101 0111
	"9"		=	0000 0000 1111 1111			1001 0000 0110 1111
	"0"		=	0000 0000 1111 1111			1001 1000 0110 0111
	"*"		=	0000 0000 1111 1111			0110 1000 1001 0111
	"#"		=	0000 0000 1111 1111		 	1011 0000 0100 1111
	"ok"	=	0000 0000 1111 1111			0011 1000 1100 0111
	"up"	=	0000 0000 1111 1111			0001 1000 1110 0111
	"down"	=	0000 0000 1111 1111			0100 1010 1011 0101
	"left"	=	0000 0000 1111 1111			0001 0000 1110 1111
	"right"	=	0000 0000 1111 1111			0101 1010 1010 0101
	
*/
//********************************************************************************
//								IR_Decode_Read
//********************************************************************************	
#if (IR_Control == 1)
	unsigned int ir_read_counter;
	unsigned int ir_read_counter_buf;
	xdata unsigned char	ir_data_buf[4];
	
	void IRDecode_Read(void){
		if(FLAG.IR_Data_Decode_Finish==1){
			ir_data_buf[0] = ir_data[0];
			ir_data_buf[1] = ir_data[1];
			ir_data_buf[2] = ir_data[2];
			ir_data_buf[3] = ir_data[3];
			
			ir_data[0] = 0;ir_data[1] = 0;ir_data[2] = 0;ir_data[3] = 0;
			
			if((ir_data_buf[0]==ir_address1)&&(ir_data_buf[1]==ir_address2)){
				if((ir_data_buf[2]==IR_DATA_1_1)&&(ir_data_buf[3]==IR_DATA_1_2)){		//"1"
					RF_Channel = R_1_SPEED;
				}
				else if((ir_data_buf[2]==IR_DATA_2_1)&&(ir_data_buf[3]==IR_DATA_2_2)){	//"2"
					RF_Channel = R_2_SPEED;
				}
				else if((ir_data_buf[2]==IR_DATA_3_1)&&(ir_data_buf[3]==IR_DATA_3_2)){	//"3"
					RF_Channel = R_3_SPEED;
				}
				else if((ir_data_buf[2]==IR_DATA_4_1)&&(ir_data_buf[3]==IR_DATA_4_2)){	//"4"
					RF_Channel = R_4_SPEED;
				}
				else if((ir_data_buf[2]==IR_DATA_off_1)&&(ir_data_buf[3]==IR_DATA_off_2)){	//"OFF"
					RF_Channel = R_OFF;
				}
			}
			if(RF_Channel!=R_INIT){					// Execute remote control key
				#if (dIPWM_MODE == 1)
					if(FLAG.Buzzer_SW==0){
						FLAG.Buzzer_SW = 1;
						ipwm_counter = 0;
					}
				#endif
				RF_IR_Fun();
			
			// #if (EEPROM_MODE==1)
				// if(RF_Channel!=RF_Channel_temp){
					// EEP_Erase();
					// EEP_Write(0x00,SpeedNum);		//Remember the number of remote control speed segments after power down
					// EEP_Write(0x01,RF_Address[0]);
					// EEP_Write(0x02,RF_Address[1]);
					// EEP_Write(0x03,RF_Address[2]);
				// }
			// #endif
			}
			FLAG.IR_Data_Decode_Finish = 0;
			EX1 = 1;
		}
	}
#endif